/*+ TsipDemo.cpp
 *
 ******************************************************************************
 *
 *                        Trimble Navigation Limited
 *                           645 North Mary Avenue
 *                              P.O. Box 3642
 *                         Sunnyvale, CA 94088-3642
 *
 ******************************************************************************
 *
 *    Copyright  2005 Trimble Navigation Ltd.
 *    All Rights Reserved
 *
 ******************************************************************************
 *
 * Description:
 *    This file implements the main program class.
 *            
 * Revision History:
 *    05-18-2005    Mike Priven
 *                  Written
 *
 * Notes:
 *
-*/

/*---------------------------------------------------------------------------*\
 |                         I N C L U D E   F I L E S
\*---------------------------------------------------------------------------*/
#include "stdafx.h"
#include "TsipDemo.h"
#include "TsipWindow.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*---------------------------------------------------------------------------*\
 |                      G L O B A L   V A R I A B L E S
\*---------------------------------------------------------------------------*/
CMainApp theApp (APP_NAME);


/*---------------------------------------------------------------------------*\
 |                    M E T H O D   D E F I N I T I O N S
\*---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
Function:       BEGIN_MESSAGE_MAP (theClass, baseClass)

Description:    Defines a message map for this class. Matches a windows message
                with a callback function. The framework will call this function
                once the message associated with it has been received.

Parameters:     theClass - specifies the name of the class whose message map
                this is
                baseClass - specifies the name of the base class of theClass

Return Value:   none
-----------------------------------------------------------------------------*/
BEGIN_MESSAGE_MAP(CMainApp, CWinApp)
    //{{AFX_MSG_MAP(CMainApp)
    //}}AFX_MSG
    ON_COMMAND(ID_HELP, CWinApp::OnHelp)

END_MESSAGE_MAP()

/*-----------------------------------------------------------------------------
Function:       <constructor>

Description:    A constructor for this class. Called when a new object of this
                class is created.

Parameters:     name - a title for this application

Return Value:   none
-----------------------------------------------------------------------------*/
CMainApp::CMainApp(CString name) : CWinApp(name)
{
}

/*-----------------------------------------------------------------------------
Function:       InitInstance

Description:    Initializes an application instance.

Parameters:     none

Return Value:   Nonzero if initialization is successful; otherwise 0.
-----------------------------------------------------------------------------*/
BOOL CMainApp::InitInstance()
{
    SetRegistryKey ("Trimble Navigation Ltd.");

    AfxInitRichEdit();

    m_pMainWndDlg = new CTsipWindow();
    m_pMainWnd    = m_pMainWndDlg;

    m_pMainWndDlg->DoModal();

    return FALSE;
}

/*-----------------------------------------------------------------------------
Function:       ExitInstance

Description:    Called on exit to clean up everything       

Parameters:     none

Return Value:   The applications exit code; 0 indicates no errors, and values 
                greater than 0 indicate an error.
-----------------------------------------------------------------------------*/
int CMainApp::ExitInstance() 
{
    if (m_pMainWndDlg != NULL) 
    {
        delete m_pMainWndDlg;
    }

    return CWinApp::ExitInstance();
}
